/*******************************************************************************
  MPLAB Harmony Application Source File
  
  Company:
    Microchip Technology Inc.
  
  File Name:
    app.c

  Summary:
    This file contains the source code for the MPLAB Harmony application.

  Description:
    This file contains the source code for the MPLAB Harmony application.  It 
    implements the logic of the application's state machine and it may call 
    API routines of other MPLAB Harmony modules in the system, such as drivers,
    system services, and middleware.  However, it does not call any of the
    system interfaces (such as the "Initialize" and "Tasks" functions) of any of
    the modules in the system or make any assumptions about when those functions
    are called.  That is the responsibility of the configuration-specific system
    files.
 *******************************************************************************/

// DOM-IGNORE-BEGIN
/*******************************************************************************
Copyright (c) 2013-2014 released Microchip Technology Inc.  All rights reserved.

Microchip licenses to you the right to use, modify, copy and distribute
Software only when embedded on a Microchip microcontroller or digital signal
controller that is integrated into your product or third party product
(pursuant to the sublicense terms in the accompanying license agreement).

You should refer to the license agreement accompanying this Software for
additional information regarding your rights and obligations.

SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
MERCHANTABILITY, TITLE, NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE.
IN NO EVENT SHALL MICROCHIP OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER
CONTRACT, NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR
OTHER LEGAL EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES
INCLUDING BUT NOT LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE OR
CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT OF
SUBSTITUTE GOODS, TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES
(INCLUDING BUT NOT LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.
 *******************************************************************************/
// DOM-IGNORE-END


// *****************************************************************************
// *****************************************************************************
// Section: Included Files 
// *****************************************************************************
// *****************************************************************************

#include "app.h"


//ΏۃL[{[hF@{106/109L[{[h

#include "stdio.h"


char Buf[32];
char strUART[16];
char moji_Esc[] = "Esc";
char moji_Tab[] = "Tab";
char moji_Enter[] = "Enter";
char moji_BackSpace[] = "Back Space";
char moji_CapsLock[] = "Caps Lock";
char moji_PrintScreen[] = "PrintScreen";    //Max11iUARTMj
char moji_ScrollLock[] = "Scroll Lock";
char moji_PauseBreak[] = "Pause Break";
char moji_Insert[] = "Insert";
char moji_PageUp[] = "Page Up";
char moji_Delete[] = "Delete";
char moji_End[] = "End";
char moji_Home[] = "Home";
char moji_PageDown[] = "Page Down";
char moji_ArrowRight[] = "Arrow Right";
char moji_ArrowLeft[] = "Arrow Left";
char moji_ArrowDown[] = "Arrow Down";
char moji_ArrowUp[] = "Arrow Up";
char moji_NumLock[] = "Num Lock";
char moji_Kanji[] = "Kanji";
char moji_MuHenkan[] = "MuHenkan";
char moji_Henkan[] = "Henkan";
char moji_Katakana[] = "Katakana";
char moji_Menu[] = "Menu";
char moji_F1[] = "F1";
char moji_F2[] = "F2";
char moji_F3[] = "F3";
char moji_F4[] = "F4";
char moji_F5[] = "F5";
char moji_F6[] = "F6";
char moji_F7[] = "F7";
char moji_F8[] = "F8";
char moji_F9[] = "F9";
char moji_F10[] = "F10";
char moji_F11[] = "F11";
char moji_F12[] = "F12";
char moji_10keyEnter[] = "10key Enter";


int delay_Clock = 200000000;   //200MHz

void delay_us(volatile unsigned int usec)        //1secx
{
        volatile  int count;

        count = (int)(delay_Clock/20000000)*usec;
        do      //@at@200MH (Clock=200000000)
        {       //delay_us(1000)F1000.4sec  delay_us(100)F100.6sec  delay_us(10):10.5sec@@delay_us(1)F1.5sec
                asm("NOP"); asm("NOP"); asm("NOP"); asm("NOP"); asm("NOP");asm("NOP");
                asm("NOP"); asm("NOP"); asm("NOP"); asm("NOP"); asm("NOP"); asm("NOP");

                count--;
        }while(count != 0);
}

void delay_ms(volatile unsigned int msec)        //1msecx
{
        volatile unsigned int i;         //Fat200MH (Clock=200000000)//delay_ms(1)F 1.0006msec   delay_ms(100)F100.04msec

        for(i=0; i<msec; i++)
        delay_us(1000);
}



// *****************************************************************************
// *****************************************************************************
// Section: Global Data Definitions
// *****************************************************************************
// *****************************************************************************

/* Usage ID to Key map table */
const char *keyValue[] = { 
//CL[ { t@NVL[  ------------------------------------------------------------------------
//                                                   keycode̒l
//                                              10i\@16i\    
                          "No event indicated",     //0     //0x00     
                          "ErrorRoll Over",         //1     //0x01
                          "POSTFail",               //2     //0x02
                          "Error Undefined",        //3     //0x03
                          "a",                      //4     //0x04 
                          "b",                      //5     //0x05
                          "c",                      //6     //0x06
                          "d",                      //7     //0x07
                          "e",                      //8     //0x08
                          "f",                      //9     //0x09
                          "g",                      //10    //0x0A
                          "h",                      //11    //0x0B
                          "i",                      //12    //0x0C
                          "j",                      //13    //0x0D
                          "k",                      //14    //0x0E
                          "l",                      //15    //0x0F
                          "m",                      //16    //0x10
                          "n",                      //17    //0x11
                          "o",                      //18    //0x12
                          "p",                      //19    //0x13
                          "q",                      //20    //0x14
                          "r",                      //21    //0x15
                          "s",                      //22    //0x16
                          "t",                      //23    //0x17
                          "u",                      //24    //0x18
                          "v",                      //25    //0x19
                          "w",                      //26    //0x1A
                          "x",                      //27    //0x1B
                          "y",                      //28    //0x1C
                          "z",                      //29    //0x1D
                          "1",                      //30    //0x1E
                          "2",                      //31    //0x1F
                          "3",                      //32    //0x20
                          "4",                      //33    //0x21    
                          "5",                      //34    //0x22
                          "6",                      //35    //0x23
                          "7",                      //36    //0x24
                          "8",                      //37    //0x25
                          "9",                      //38    //0x26
                          "0",                      //39    //0x27
                          "ENTER",                  //40    //0x28
                          "ESCAPE",                 //41    //0x29
                          "BACKSPACE",              //42    //0x2A
                          "TAB",                    //43    //0x2B
                          "SPACEBAR",               //44    //0x2C
                          "-",                      //45    //0x2D
                          "=",                      //46    //0x2E      // "^L[" at {106/109L[{[h
                          "[",                      //47    //0x2F      // "@L[" at {106/109L[{[h
                          "]",                      //48    //0x30      // "[L[" at {106/109L[{[h
                          "\\0",                    //49    //0x31       
                          "~",                      //50    //0x32      // "]L[" at {106/109L[{[h
                          ";",                      //51    //0x33      
                          "'",                      //52    //0x34      // ":L[" at {106/109L[{[h
                          "GRAVE ACCENT",           //53    //0x35      //"p/Sp L["@at {106/109L[{[h
                          ",",                      //54    //0x36
                          ".",                      //55    //0x37
                          "/",                      //56    //0x38
                          "CAPS LOCK",              //57    //0x39
                          "F1",                     //58    //0x3A
                          "F2",                     //59    //0x3B
                          "F3",                     //60    //0x3C
                          "F4",                     //61    //0x3D
                          "F5",                     //62    //0x3E
                          "F6",                     //63    //0x3F
                          "F7",                     //64    //0x40
                          "F8",                     //65    //0x41
                          "F9",                     //66    //0x42
                          "F10",                    //67    //0x43
                          "F11",                    //68    //0x44
                          "F12"                     //69    //0x45
                                  

//                        "Print Screen"            //70    //0x46
//                        "Scroll Lock"             //71    //0x47                                    
//                        "Pause/Break"             //72    //0x48
//                        "Insert"                  //73    //0x49
//                        "home"                    //74    //0x4A
//                        "Page Up"                 //75    //0x4B                                  
//                        "delete"                  //76    //0x4C
//                        "end"                     //77    //0x4D
//                        "Page Down"               //78    //0x4E
//                        "Right Arrow"             //79    //0x4F
//                        "Left Arrow"              //80    //0x50 
//                        "Down Arrow"              //81    //0x51                                  
//                        "Up Arrow"                //82    //0x52
//                        "Num Lock"                //83    //0x53 
//                        "LEFT ALT"                //226   //0xE2  //Reserved  //keyCodeł͌ĂяoȂ(at Harmony 2.04)
//                        "RIGHT ALT"               //230   //0xE6  //Reserved  //keyCodeł͌ĂяoȂ(at Harmony 2.04) 
//                        "UNDER BAR"               //4294967175    //0xFFFFFF87
//                        "J^Ji"                //4294967176    //0xFFFFFF88                                  
//                        "\"                       //4294967177    //0xFFFFFF89
//                        "ϊ"                    //4294967178    //0xFFFFFF8A                                  
//                        "ϊ"                  //4294967179    //0xFFFFFF8B
//                        "Windows(E)"                                         //keyCode ݒȂ
//                        "Windows()"                                         //keyCode ݒȂ
//                        "Menu"                    //101   //0x65                                  
//                        "Shift(E)"                                           //keyCode ݒȂ
//                        "Shift()"                                           //keyCode ݒȂ
//                        "Ctrl(E)"                                            //KeyCode ݒȂ
//                        "Ctrl()"                                            //KeyCode ݒȂ
//                        "Alt(E)"                                             //KeyCode ݒȂ                                    
//                        "Alt()"                                             //KeyCode ݒȂ                                      

//@eL[  ---------------------------------------------------------------------------------------                                  
//                        "/_keypad"                //84    //0x54
//                        "*_keypad"                //85    //0x55
//                        "-_keypad"                //86    //0x56
//                        "+_keypad"                //87    //0x57
//                        "Enter"                   //88    //0x58
//                        "1_keypad"                //89    //0x59
//                        "2_keypad"                //90    //0x5A
//                        "3_keypad"                //91    //0x5B
//                        "4_keypad"                //92    //0x5C
//                        "5_keypad"                //93    //0x5D
//                        "6_keypad"                //94    //0x5E
//                        "7_keypad"                //95    //0x5F
//                        "8_keypad"                //96    //0x60
//                        "9_keypad"                //97    //0x61
//                        "0_keypad"                //98    //0x62
//                        "._keypad"                //99    //0x63
                                  
//@eL[iVtg̏ꍇj@@ΉiVtgȂƑSj                               
                          
                      };

// *****************************************************************************
/* Application Data

  Summary:
    Holds application data

  Description:
    This structure holds the application's data.

  Remarks:
    This structure should be initialized by the APP_Initialize function.
    
    Application strings and buffers are be defined outside this structure.
*/

APP_DATA appData;


// *****************************************************************************
// *****************************************************************************
// Section: Application Local Routines
// *****************************************************************************


// *****************************************************************************
// *****************************************************************************
// Section: Application Callback Functions
// *****************************************************************************
// *****************************************************************************

/*******************************************************
 * USB HOST Layer Events - Host Event Handler
 *******************************************************/

USB_HOST_EVENT_RESPONSE APP_USBHostEventHandler (USB_HOST_EVENT event, void * eventData, uintptr_t context)
{
    switch(event)
    {
        case USB_HOST_EVENT_DEVICE_UNSUPPORTED:
            break;
        default:
            break;
    }
    return USB_HOST_EVENT_RESPONSE_NONE;
}

/*******************************************************
 * USB HOST HID Layer Events - Application Event Handler
 *******************************************************/

void APP_USBHostHIDKeyboardEventHandler(USB_HOST_HID_KEYBOARD_HANDLE handle, 
        USB_HOST_HID_KEYBOARD_EVENT event, void * pData)
{   
    switch ( event)
    {
        case USB_HOST_HID_KEYBOARD_EVENT_ATTACH:
            appData.handle = handle;
            appData.state =  APP_STATE_DEVICE_ATTACHED;
            appData.nBytesWritten = 0;
            appData.stringReady = false;
            memset(&appData.string, 0, sizeof(appData.string));
            memset(&appData.lastData, 0, sizeof(appData.lastData));
            appData.stringSize = 0;
            appData.capsLockPressed = false;
            appData.scrollLockPressed = false;
            appData.numLockPressed = false;
            appData.outputReport = 0;
            break;

        case USB_HOST_HID_KEYBOARD_EVENT_DETACH:
            appData.handle = handle;
            appData.state = APP_STATE_DEVICE_DETACHED;
            appData.nBytesWritten = 0;
            appData.stringReady = false;
            appData.usartTaskState = APP_USART_STATE_CHECK_FOR_STRING_TO_SEND;
            memset(&appData.string, 0, sizeof(appData.string));
            memset(&appData.lastData, 0, sizeof(appData.lastData));
            appData.stringSize = 0;
            appData.capsLockPressed = false;
            appData.scrollLockPressed = false;
            appData.numLockPressed = false;
            appData.outputReport = 0;
            break;

        case USB_HOST_HID_KEYBOARD_EVENT_REPORT_RECEIVED:
            appData.handle = handle;
            appData.state = APP_STATE_READ_HID;
            /* Keyboard Data from device */
            memcpy(&appData.data, pData, sizeof(appData.data));
            break;

        default:
            break;
    }
    return;
}


// *****************************************************************************
// *****************************************************************************
// Section: Application Local Functions
// *****************************************************************************
// *****************************************************************************

/* TODO:  Add any necessary local functions.
*/

void ys_Char(USB_HID_KEYBOARD_KEYPAD _keyCode)    //pL[
{    
    //I2CLN^t\
    lcd_ACM1602_cmd_i2c(0x80);  //1sڂ̐擪
    sprintf(Buf,"key=0x%02X                     ",_keyCode);  
    lcd_ACM1602_str_i2c(Buf);
    
    lcd_ACM1602_cmd_i2c(0xC0);  //2sڂ̐擪
    sprintf(Buf,"%c               ",appData.string[appData.currentOffset]);
    lcd_ACM1602_str_i2c(Buf);
}


void ys_Char_0xXX(USB_HID_KEYBOARD_KEYPAD _keyCode, char myChar)    //ʋLL[
{
    appData.string[appData.currentOffset] = myChar;    //UARTo͂ 
    
    //I2CLN^t\
    lcd_ACM1602_cmd_i2c(0x80);  //1sڂ̐擪
    sprintf(Buf,"key=0x%02X                     ",_keyCode);  
    lcd_ACM1602_str_i2c(Buf);
    
    lcd_ACM1602_cmd_i2c(0xC0);  //2sڂ̐擪
    sprintf(Buf,"%c               ",appData.string[appData.currentOffset]);
    lcd_ACM1602_str_i2c(Buf);
}

void ys_Char_0xFFFF(USB_HID_KEYBOARD_KEYPAD _keyCode, char myChar)      //ʈL[F@@\@_
{
    appData.string[appData.currentOffset] = myChar;    //UARTo͂ 
    
    //I2CLN^t\
    lcd_ACM1602_cmd_i2c(0x80);  //1sڂ̐擪
    sprintf(Buf,"key=0x%X                     ",_keyCode);  
    lcd_ACM1602_str_i2c(Buf);
    
    lcd_ACM1602_cmd_i2c(0xC0);  //2sڂ̐擪
    sprintf(Buf,"%c               ",appData.string[appData.currentOffset]);//
    lcd_ACM1602_str_i2c(Buf);
}

void ys_Function_Enter(USB_HID_KEYBOARD_KEYPAD _keyCode)  //G^[L[
{
    memcpy(&appData.string[appData.currentOffset], "\r\n", strlen("\r\n"));  //UARTo͂
    
    //I2CLN^t\
    lcd_ACM1602_cmd_i2c(0x80);  //1sڂ̐擪
    sprintf(Buf,"key=0x%02X                     ",_keyCode);    //L[ނ16iŕ\
    lcd_ACM1602_str_i2c(Buf);
    
    lcd_ACM1602_cmd_i2c(0xC0);  //2sڂ̐擪
    sprintf(Buf,"Enter              ");
    lcd_ACM1602_str_i2c(Buf); 
}
  
void ys_Function_0xXX(USB_HID_KEYBOARD_KEYPAD _keyCode, char* str0)  //ʋ@\L[
{
    strcpy(strUART,"\r\n");
    strncat(strUART, str0, strlen(str0));   //UARTo: o͑Oɉs(\r\n)
    memcpy(&appData.string[appData.currentOffset], strUART, strlen(strUART));  //UARTo͂ 
    
    //I2CLN^t\
    lcd_ACM1602_cmd_i2c(0x80);  //1sڂ̐擪
    sprintf(Buf,"key=0x%02X                     ",_keyCode);    //L[ނ16iŕ\
    lcd_ACM1602_str_i2c(Buf);
    
    lcd_ACM1602_cmd_i2c(0xC0);  //2sڂ̐擪
    sprintf(Buf,"%s                    ",str0);
    lcd_ACM1602_str_i2c(Buf);   
}

void ys_Function_0xFFFF(USB_HID_KEYBOARD_KEYPAD _keyCode, char* str0)  //ʈ@\L[   //"J^Ji" "ϊ" "ϊ"
{
    strcpy(strUART,"\r\n");
    strncat(strUART, str0, strlen(str0));   //UARTo: o͑Oɉs(\r\n)
    memcpy(&appData.string[appData.currentOffset], strUART, strlen(strUART));  //UARTo͂ 
    
    //I2CLN^t\
    lcd_ACM1602_cmd_i2c(0x80);  //1sڂ̐擪
    sprintf(Buf,"key=0x%X                     ",_keyCode);    //L[ނ16iŕ\
    lcd_ACM1602_str_i2c(Buf);
    
    lcd_ACM1602_cmd_i2c(0xC0);  //2sڂ̐擪
    sprintf(Buf,"%s                    ",str0);
    lcd_ACM1602_str_i2c(Buf);    
}

void ys_NonShift_MapKey(USB_HID_KEYBOARD_KEYPAD keyCode, uint8_t outputReport) //Vtg[h̃L[}bv֐
{
    //keyCodȇΉ a,b,c,...x,y,z, 1,2,...,8,9,0 ̏ꍇ
    if((keyCode >= USB_HID_KEYBOARD_KEYPAD_KEYBOARD_A) &&       // a,b,c,...x,y,z, 1,2,...,8,9,0 
        (keyCode <= USB_HID_KEYBOARD_KEYPAD_KEYBOARD_0_AND_CLOSE_PARENTHESIS))  //0x04 <= keyCode <= 0x27
    { 
        memcpy(&appData.string[appData.currentOffset], keyValue[keyCode], strlen(keyValue[keyCode]));
        ys_Char(keyCode);   //LN^t\
    }
     
    //keyCode   
    switch(keyCode)
    {
        case 0x2D:          //Minus -
            ys_Char_0xXX(keyCode, '-'); break;
        case 0x2E:          //Carrot ^
            ys_Char_0xXX(keyCode, '^'); break;
        case 0xFFFFFF89:    //~ \     
            ys_Char_0xFFFF(keyCode, '\\'); break;
        case 0x2F:          //Abg}[N @         
            ys_Char_0xXX(keyCode, '@'); break;
        case 0x30 :         //I[v劇 [        
            ys_Char_0xXX(keyCode, '['); break;
        case 0x33:          //Z~R ;         
            ys_Char_0xXX(keyCode, ';'); break;
        case 0x34:          //R :         
            ys_Char_0xXX(keyCode, ':'); break;
        case 0x32:          //N[Y劇 ]         
            ys_Char_0xXX(keyCode, ']'); break;
        case 0x36:          //J} ,         
            ys_Char_0xXX(keyCode, ','); break;
        case 0x37:          //sIh .         
            ys_Char_0xXX(keyCode, '.'); break;
        case 0x38:          //XbV /         
            ys_Char_0xXX(keyCode, '/'); break;
        case 0xFFFFFF87:    //A_[o[ _     
            ys_Char_0xFFFF(keyCode, '\\'); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYBOARD_TAB:              //0x28  //^u Tab
             ys_Function_0xXX(keyCode, moji_Tab); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYPAD_BACK_SLASH:         //0x54  //eL[@XbV / 
            ys_Char_0xXX(keyCode, '/'); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYPAD_ASTERISK:           //0x55  //eL[@AX^XN * 
            ys_Char_0xXX(keyCode, '*'); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYPAD_MINUS:              //0x56  //eL[@}CiX -  
            ys_Char_0xXX(keyCode, '-'); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYPAD_PLUS:               //0x57  //eL[@vX + 
            ys_Char_0xXX(keyCode, '+'); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYPAD_ENTER:              //0x58  //eL[G^[ Enter
            ys_Function_0xXX(keyCode, moji_10keyEnter); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYPAD_1_AND_END:          //0x59  //eL[1   1
            ys_Char_0xXX(keyCode, '1'); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYPAD_2_AND_DOWN_ARROW:   //0x5A  //eL[2   2
            ys_Char_0xXX(keyCode, '2'); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYPAD_3_AND_PAGE_DOWN:    //0x5B  //eL[3   3
            ys_Char_0xXX(keyCode, '3'); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYPAD_4_AND_LEFT_ARROW:   //0x5C  //eL[4   4
            ys_Char_0xXX(keyCode, '4'); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYPAD_5:                  //0x5D  //eL[5   5
            ys_Char_0xXX(keyCode, '5'); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYPAD_6_AND_RIGHT_ARROW:  //0x5E  //eL[6   6
            ys_Char_0xXX(keyCode, '6'); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYPAD_7_AND_HOME:         //0x5F  //eL[7   7
            ys_Char_0xXX(keyCode, '7'); break;
        case  USB_HID_KEYBOARD_KEYPAD_KEYPAD_8_AND_UP_ARROW:    //0x60  //eL[8   8
            ys_Char_0xXX(keyCode, '8'); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYPAD_9_AND_PAGE_UP:      //0x61  //eL[9   9
            ys_Char_0xXX(keyCode, '9'); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYPAD_0_AND_INSERT:       //0x62  //eL[0   0
            ys_Char_0xXX(keyCode, '0'); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYPAD_PERIOD_AND_DELETE:  //0x63  //eL[sIh .
            ys_Char_0xXX(keyCode, '.'); break;
        default: break;
    }
    
    
}

void ys_Shift_MapKey(USB_HID_KEYBOARD_KEYPAD keyCode, uint8_t outputReport)    //Vtg[h̃L[}bv֐
{
     //keyCodȇΉ a,b,c,...x,y,z ̏ꍇ
     if((keyCode >= USB_HID_KEYBOARD_KEYPAD_KEYBOARD_A) &&       // a,b,c,...x,y,z
        (keyCode <= USB_HID_KEYBOARD_KEYPAD_KEYBOARD_Z))    //0x04 <= keyCode <= 0x1D
     {
        memcpy(&appData.string[appData.currentOffset], keyValue[keyCode], strlen(keyValue[keyCode]));
        appData.string[appData.currentOffset] = appData.string[appData.currentOffset] - 32;
        ys_Char(keyCode);   //LN^t\
     }
     
     //keyCodȇΉ !,",#,$,%,&,',(,) ̏ꍇ
     if((keyCode >= USB_HID_KEYBOARD_KEYPAD_KEYBOARD_1_AND_EXCLAMATION_POINT) &&    //!,",#,$,%,&,',(,) 
        (keyCode <= USB_HID_KEYBOARD_KEYPAD_KEYBOARD_9_AND_OPEN_PARENTHESIS))     //0x1E <= keyCode <= 0x26
     {
        memcpy(&appData.string[appData.currentOffset], keyValue[keyCode], strlen(keyValue[keyCode]));
        appData.string[appData.currentOffset] = appData.string[appData.currentOffset] - 16;
        ys_Char(keyCode);   //LN^t\
     }
     
    //keyCode 
    switch(keyCode)
    {
        case 0x2D:          //L[F MINUS -  //VtgFEQUAL = 
            ys_Char_0xXX(keyCode, '='); break;
        case 0x2E:          //L[F Carrot ^ //VtgFTILDE ~
             ys_Char_0xXX(keyCode, '~'); break;
        case 0xFFFFFF89:    //L[F~ \    //VtgFPIPE |
            ys_Char_0xFFFF(keyCode, '|'); break;
        case 0x2F:          //L[FAbg}[N @@//VtgFGRAVE ACCENT `  
            ys_Char_0xXX(keyCode, '`'); break;
        case 0x30 :         //L[FI[v劇 [  //VtgF@I[v {
            ys_Char_0xXX(keyCode, '{'); break;
        case 0x33:          //L[FZ~R ;  //VtgFvX + 
            ys_Char_0xXX(keyCode, '+'); break;
        case 0x34:          //L[FR :@//VtgFAX^XN *
            ys_Char_0xXX(keyCode, '*'); break;
        case 0x32:          //L[FN[Y劇 ]  //VtgFN[Y }
            ys_Char_0xXX(keyCode, '}'); break;
        case 0x36:          //L[FJ} ,  //VtgF@i傤jȂ <
            ys_Char_0xXX(keyCode, '<'); break;
        case 0x37:          //L[FsIh .  //VtgF@ijȂ >
            ys_Char_0xXX(keyCode, '>'); break;
        case 0x38:          //L[FXbV /  //VtgF@^╄ ?
            ys_Char_0xXX(keyCode, '?'); break;
        case 0xFFFFFF87:    //L[:A_[o[_  //VtgFA_[o[ _
            ys_Char_0xFFFF(keyCode, '_'); break; 
        default: break;
    }
}


void APP_MapKeyToUsage(USB_HID_KEYBOARD_KEYPAD keyCode)     //keyCode: ŌL[R[h
{
    uint8_t outputReport = 0;
 
    outputReport = appData.outputReport;
    
    if(keyCode == USB_HID_KEYBOARD_KEYPAD_KEYBOARD_CAPS_LOCK)
    {
        /* CAPS LOCK pressed */
        if(appData.capsLockPressed == false)    //CAPS_LOCK]
        {
            appData.capsLockPressed = true;
            outputReport = outputReport | 0x2;  //b1 = 1@ɃZbg
        }
        else
        {
            appData.capsLockPressed = false;
            outputReport = outputReport & 0xFD; //b1 = 0@ɃZbg
        }    
    }
    
    if(keyCode == USB_HID_KEYBOARD_KEYPAD_KEYBOARD_SCROLL_LOCK)
    {
        /* SCROLL LOCK pressed */       //SCROLL_LOCK]
        if(appData.scrollLockPressed == false)
        {
            appData.scrollLockPressed = true;
            outputReport = outputReport | 0x4;  //b3 = 1@ɃZbg
        }
        else
        {
            appData.scrollLockPressed = false;
            outputReport = outputReport & 0xFB; //b3 = 0 ɃZbg
        }
    }
    
    if(keyCode == USB_HID_KEYBOARD_KEYPAD_KEYPAD_NUM_LOCK_AND_CLEAR)
    {
        /* NUM LOCK pressed */  //NUM_LOCK]
        if(appData.numLockPressed == false)
        {
            appData.numLockPressed = true;
            outputReport = outputReport | 0x1;  //b0 = 1 ɃZbg
        }
        else
        {
            appData.numLockPressed = false;
            outputReport = outputReport & 0xFE; //b0 = 0 ɃZbg
        }
    }

    //L[VtgL    
    if(appData.capsLockPressed ||   //LbvXL[Ăꍇ
        appData.data.modifierKeysData.leftShift ||  //VtgL[Ăꍇ 
        appData.data.modifierKeysData.rightShift)   //EVtgL[Ăꍇ
            ys_Shift_MapKey(keyCode, outputReport);    //Vtg[h̃L[}bv֐
    else    ys_NonShift_MapKey(keyCode, outputReport);    //Vtg[h̃L[}bv֐ 
    
        
    switch(keyCode)     //Vtg/Vtgɖ֌WȃL[
    {    
        case USB_HID_KEYBOARD_KEYPAD_KEYBOARD_ESCAPE:       //0x29  //GXP[v Esc
            ys_Function_0xXX(keyCode, moji_Esc); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYBOARD_RETURN_ENTER: //0x28  //G^[ Enter
            ys_Function_Enter(keyCode); break; 
        case  USB_HID_KEYBOARD_KEYPAD_KEYBOARD_DELETE:      //0x2A  //obNXy[X Back Space
             ys_Function_0xXX(keyCode, moji_BackSpace); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYBOARD_CAPS_LOCK:    //0x39 //LbvXbN Caps Lock
            ys_Function_0xXX(keyCode, moji_CapsLock); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYBOARD_PRINT_SCREEN: //0x46  //vgXN[ Print Screen
            ys_Function_0xXX(keyCode, moji_PrintScreen);  break;
        case USB_HID_KEYBOARD_KEYPAD_KEYBOARD_SCROLL_LOCK:  //0x47  //XN[bN Scroll Lock
            ys_Function_0xXX(keyCode, moji_ScrollLock); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYBOARD_PAUSE:        //0x48  //|[Y/uCN Pause/Break
            ys_Function_0xXX(keyCode, moji_PauseBreak); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYBOARD_INSERT:       //0x49  //CT[g Insert
            ys_Function_0xXX(keyCode, moji_Insert); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYBOARD_HOME:         //0x4A  //z[ Home
            ys_Function_0xXX(keyCode, moji_Home); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYBOARD_PAGE_UP:      //0x4B  //y[WAbv Page Up
            ys_Function_0xXX(keyCode, moji_PageUp); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYBOARD_DELETE_FORWARD:   //0x4C  //f[g Delete
             ys_Function_0xXX(keyCode, moji_Delete); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYBOARD_END:          //0x4D  //Gh End
            ys_Function_0xXX(keyCode, moji_End); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYBOARD_PAGE_DOWN:    //0x4E  //y[W_E Page Down
            ys_Function_0xXX(keyCode, moji_PageDown); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYBOARD_RIGHT_ARROW:  //0x4F  //E 
            ys_Function_0xXX(keyCode, moji_ArrowRight); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYBOARD_LEFT_ARROW:   //0x50  // 
             ys_Function_0xXX(keyCode, moji_ArrowLeft); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYBOARD_DOWN_ARROW:   //0x51  // 
            ys_Function_0xXX(keyCode, moji_ArrowDown); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYBOARD_UP_ARROW:     //0x52  // 
            ys_Function_0xXX(keyCode, moji_ArrowUp); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYPAD_NUM_LOCK_AND_CLEAR: //0x53  //L[bN Num Lock
            ys_Function_0xXX(keyCode, moji_NumLock); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYBOARD_SPACEBAR:     //0x2C  //Xy[Xo[  
            ys_Char_0xXX(keyCode, ' '); break;
        case 0x35:      //p/Sp@
            ys_Function_0xXX(keyCode, moji_Kanji); break;
        case 0xFFFFFF8B :   //ϊ
            ys_Function_0xFFFF(keyCode, moji_MuHenkan); break;
        case 0xFFFFFF8A:    //ϊ      
            ys_Function_0xFFFF(keyCode, moji_Henkan); break;
        case 0xFFFFFF88:    //J^Ji Ђ炪 [}
            ys_Function_0xFFFF(keyCode, moji_Katakana); break;
        case 0x65:       //Menu (}L)
            ys_Function_0xXX(keyCode, moji_Menu); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYBOARD_F1:   //0x3A  //F1
            ys_Function_0xXX(keyCode, moji_F1); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYBOARD_F2:   //0x3B //F2
            ys_Function_0xXX(keyCode, moji_F2); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYBOARD_F3:   //0x3C  //F3
            ys_Function_0xXX(keyCode, moji_F3); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYBOARD_F4:   //0x3D //F4
            ys_Function_0xXX(keyCode, moji_F4); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYBOARD_F5:   //0x3E  //F5
            ys_Function_0xXX(keyCode, moji_F5); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYBOARD_F6:   //0x3F //F6
           ys_Function_0xXX(keyCode, moji_F6); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYBOARD_F7:   //0x40  //F7
            ys_Function_0xXX(keyCode, moji_F7); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYBOARD_F8:   //0x41 //F8
            ys_Function_0xXX(keyCode, moji_F8); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYBOARD_F9:   //0x42  //F9
            ys_Function_0xXX(keyCode, moji_F9); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYBOARD_F10:   //0x43 //F10
           ys_Function_0xXX(keyCode, moji_F10); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYBOARD_F11:   //0x45  //F11
            ys_Function_0xXX(keyCode, moji_F11); break;
        case USB_HID_KEYBOARD_KEYPAD_KEYBOARD_F12:   //0x46 //F12
            ys_Function_0xXX(keyCode, moji_F12); break;
        default: break;
    }
    
     appData.currentOffset = appData.currentOffset + sizeof(keyValue[keyCode]);
     //APP_TASKS()1ԂɕŌsꂽꍇAappData.string[64]ɕ̃L[f[^ێ

    
}

// *****************************************************************************
// *****************************************************************************
// Section: Application Initialization and State Machine Functions
// *****************************************************************************
// *****************************************************************************

/*******************************************************************************
  Function:
    void APP_Initialize ( void )

  Remarks:
    See prototype in app.h.
 */

void APP_Initialize ( void )
{
    /* Place the App state machine in its initial state. */
    memset(&appData, 0, sizeof(appData));
    appData.state = APP_STATE_INIT;
    appData.usartTaskState = APP_USART_STATE_DRIVER_OPEN;
    
         
    
    lcd_ACM1602_init_i2c();     //I2CC^[tF[Xt
    lcd_ACM1602_cmd_i2c(0x0C);    //J[\F0FFAuNF0FF
    
    lcd_ACM1602_cmd_i2c(0x80);  //1sڂ̐擪
    lcd_ACM1602_str_i2c("USB device HID          ");
    
     delay_ms(1000);
     
    lcd_ACM1602_cmd_i2c(0xC0);  //2sڂ̐擪
    lcd_ACM1602_str_i2c("  Keyboard demo          ");
    
    delay_ms(2000);
}


void APP_USART_Tasks(void)
{
    switch(appData.usartTaskState)
    {
        case APP_USART_STATE_DRIVER_OPEN:
            
            /* Try to open the USART driver */
            appData.usartDriverHandle = DRV_USART_Open(DRV_USART_INDEX_0,
                    DRV_IO_INTENT_READWRITE | DRV_IO_INTENT_NONBLOCKING);
            if(appData.usartDriverHandle != DRV_HANDLE_INVALID)
            {
                /* The driver could be opened. We should be able to send data */
                appData.usartTaskState = APP_USART_STATE_CHECK_FOR_STRING_TO_SEND;
            }
            break;
            
        case APP_USART_STATE_CHECK_FOR_STRING_TO_SEND:
            
            /* In this state we check if the there is string to be transmitted */
            if(appData.stringReady)
            {
                /* Write the string to the driver */
                appData.usartTaskState = APP_USART_STATE_DRIVER_WRITE;
                appData.nBytesWritten = 0;
            }
            
            break;
            
        case APP_USART_STATE_DRIVER_WRITE:
            
            /* Write the string to the driver. We will need to check how much
             * of the string was actually written and update the pointer and
             * size accordingly */
            //UARThCoɑM
            appData.nBytesWritten += DRV_USART_Write(appData.usartDriverHandle,     
                    appData.string + appData.nBytesWritten, appData.stringSize - appData.nBytesWritten);
            
            if(appData.nBytesWritten >= appData.stringSize)
            {
                /* This means all the data was written. Clear the flag
                 * so the application know we are done. Change the state
                 * to continue check if another string needs to be 
                 * sent. */
                
                appData.stringReady = false;
                appData.usartTaskState = APP_USART_STATE_CHECK_FOR_STRING_TO_SEND;
            }
            break;
            
        default:
            break;
    }
}

/******************************************************************************
  Function:
    void APP_Tasks ( void )

  Remarks:
    See prototype in app.h.
 */

void APP_Tasks ( void )
{
    uint64_t sysCount = 0;
    uint8_t count = 0;
    uint8_t counter = 0;
    bool foundInLast = false;   //Ō̌o
    
    appData.currentOffset = 0;
    
    /* Check the application's current state. */
    switch ( appData.state )
    {
        /* Application's initial state. */
        case APP_STATE_INIT:
            USB_HOST_EventHandlerSet(APP_USBHostEventHandler, 0);
            USB_HOST_HID_KEYBOARD_EventHandlerSet(APP_USBHostHIDKeyboardEventHandler);
            
			USB_HOST_BusEnable(0);
			appData.state = APP_STATE_WAIT_FOR_HOST_ENABLE;
            break;
			
		case APP_STATE_WAIT_FOR_HOST_ENABLE:
            /* Check if the host operation has been enabled */
            if(USB_HOST_BusIsEnabled(0))
            {
                /* This means host operation is enabled. We can
                 * move on to the next state */
                appData.state = APP_STATE_HOST_ENABLE_DONE;
            }
            break;
        case APP_STATE_HOST_ENABLE_DONE:
            appData.stringSize = 64;
            if(appData.usartTaskState == APP_USART_STATE_CHECK_FOR_STRING_TO_SEND)
            {
                memcpy(&appData.string[0], "\r\n***Connect Keyboard***\r\n",
                            sizeof("\r\n***Connect Keyboard***\r\n"));
                
                  
                lcd_ACM1602_cmd_i2c(0x80);  //1sڂ̐擪
                lcd_ACM1602_str_i2c("Please Connect         ");
    
                lcd_ACM1602_cmd_i2c(0xC0);  //2sڂ̐擪
                lcd_ACM1602_str_i2c("     Keyboard !!         ");
                
                
                
                appData.stringReady = true;
                /* The test was successful. Lets idle. */
                appData.state = APP_STATE_WAIT_FOR_DEVICE_ATTACH;
            }
            break;

        case APP_STATE_WAIT_FOR_DEVICE_ATTACH:

            /* Wait for device attach. The state machine will move
             * to the next state when the attach event
             * is received.  */

            break;

        case APP_STATE_DEVICE_ATTACHED:
            
            /* Wait for device report */
            if(appData.usartTaskState == APP_USART_STATE_CHECK_FOR_STRING_TO_SEND)
            {
                memcpy(&appData.string[0], "---Keyboard Connected---\r\n",
                        sizeof("---Keyboard Connected---\r\n"));
                
                lcd_ACM1602_cmd_i2c(0x80);  //1sڂ̐擪
                lcd_ACM1602_str_i2c("Keyboard has         ");
    
                lcd_ACM1602_cmd_i2c(0xC0);  //2sڂ̐擪
                lcd_ACM1602_str_i2c("      Connected      ");
                
                
                appData.stringReady = true;
                appData.stringSize = 64;
                appData.state = APP_STATE_READ_HID;
            }
            break;

        case APP_STATE_READ_HID:
            appData.stringReady = false;
            if(appData.usartTaskState == APP_USART_STATE_CHECK_FOR_STRING_TO_SEND)
            {
                /* We can send Data to USART but need to check*/
                appData.stringSize = 64;
                memset(&appData.string, 0, sizeof(appData.string));
                
                /* We need to display only the non modifier keys */
                for(count = 0; count < 6; count++)
                {
                    if(appData.data.nonModifierKeysData[count].event == USB_HID_KEY_PRESSED)
                    {
                        for(counter = 0; counter < 6; counter++)
                        {
                            if((appData.lastData.data.nonModifierKeysData[counter].event == USB_HID_KEY_PRESSED)
                                &&((appData.lastData.data.nonModifierKeysData[counter].keyCode == 
                                    appData.data.nonModifierKeysData[count].keyCode)))
                            {
                                sysCount = SYS_TMR_SystemCountGet ();
                                if(200 <= 1000 * 
                                        (sysCount - appData.lastData.data.nonModifierKeysData[counter].sysCount)
                                        / SYS_TMR_SystemCountFrequencyGet())
                                {
                                    foundInLast = false;
                                }
                                else
                                {
                                    foundInLast = true;
                                }
                                break;
                            }
                        }
                        if(foundInLast == false)
                        {
                            appData.stringReady = true;
                            APP_MapKeyToUsage(appData.data.nonModifierKeysData[count].keyCode);
                        }
                        else
                        {
                            /* Reset it it false for next iteration */
                            foundInLast = false;
                        }
                    }
                }
                /* Store the present to future */
                memcpy(&appData.lastData.data, &appData.data, sizeof(appData.data));
            }
            break;

        case APP_STATE_DEVICE_DETACHED:
            appData.state = APP_STATE_HOST_ENABLE_DONE;
            break;

        case APP_STATE_ERROR:

            /* The application comes here when the demo
             * has failed. Provide LED indication .*/

//            BSP_LEDOn( APP_USB_LED_1 );
            break;

        default:
            break;
    }
    /* Call the USART task routine */
    APP_USART_Tasks();  //UART]ɑM

}


/*******************************************************************************
 End of File
 */
